//===============================================================================================
// Object:			zFeedback and helper methods
//
// Description:	Support the gathering of customer feedback on help and its related context.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gFeedbackDlg = null;

//-----------------------------------------------------------------------------------------------
// zFeedback - object used to transfer data between the feedback dialog and this page
//-----------------------------------------------------------------------------------------------
function zFeedback()
{
	this.comment = "";
	this.problemType = "";
	this.topic = "";
	this.subtopic = "";
	this.contactName = "";
	this.contactPhone = "";
	this.contactEMail = "";
	this.installedStates = null;

	this.submit = _zFeedbackSubmit;
	this.techSupport = function(){ goTechSupport() };
}

//-----------------------------------------------------------------------------------------------
function _zFeedbackSubmit()
	// Submit the feedback to the server via the C++ handler
{
	// Populate the dataexchange datasrc
	setDataSrcItem( "feedbackComment", this.comment );
	setDataSrcItem( "feedbackProblemType", this.problemType );
	setDataSrcItem( "feedbackTopic", this.topic );
	setDataSrcItem( "feedbackSubtopic", this.subtopic );
	
	setDataSrcItem( "feedbackName", this.contactName );
	setDataSrcItem( "feedbackPhoneNumber", this.contactPhone );
	setDataSrcItem( "feedbackEMail", this.contactEMail );
	
	// Determine the last search string from the history list
	var query = gViewer.getLastSearchQuery();
	setDataSrcItem( "feedbackLastSearchStr", (query) ? query : "" );

	// Determine the help type and item id from the history list
	var request = gViewer.currentRequest();
	if( request )
	{
		var helpType = request.helpType;		
		if( !helpType )
		{
			if( request.filename )
			{
				// Determine the help type from the file name
				var cntType = parent.findContextTypeByFilename( request.filename );
				helpType = cntType.type;
			}
			else if( gViewer.wnd && gViewer.wnd.document && gViewer.wnd.document.title )
			{
				// Use the title from the html document
				helpType = gViewer.wnd.document.title;
			}
		}
		
		setDataSrcItem( "feedbackHelpType", (helpType) ? helpType : "" );
		
		// screen id limited to 100 characters
		var screenId = ( request.filename ) ? request.filename : request.title;
		if( !screenId ) screenId = helpType;
		
		// append the title to the screen id
		if( request.filename && request.title )
		{
			screenId += ' - ';
			screenId += request.title;
		}
		
		setDataSrcItem( "feedbackHelpScreenId", (screenId) ? screenId.substr(0,100) : "" );
	}
		
	onCmd( "submitFeedback" );
		// noncritical - ignore any failures
		
	return getLastCmdResult();		
}

//-----------------------------------------------------------------------------------------------
// Helper Methods
//-----------------------------------------------------------------------------------------------
function goFeedback()
	// Present the simple feedback loop dialog
{
	// Show the feedback dialog modelessly, if one already exists bring to the top.
	if( gFeedbackDlg && !gFeedbackDlg.closed )
	{
		// feedback dialog is still open, bring it to the top
		gFeedbackDlg.focus();	
		return;
	}
	
	var kDlgWidth = 490;
	var kDlgHeight = 600;
	
	// Create the feedback object use to transfer data between the dialog
	var feedback = new zFeedback();


	// Get C++ handler for a list of installed states,
	// the name are used as subcategories in the dialog
	//onCmd( "getInstalledStates" );
	//var args = getLastCmdResultList();
	//if( args ) feedback.installedStates = args[0];
	

	// Position the dialog within the center of the screen
	var x = (screen.availWidth - kDlgWidth)/2;
	if( x<0 ) x = 0;

	var h = kDlgHeight;
	if( h > screen.availHeight ) h = screen.availHeight;
	var y = (screen.availHeight-h)/4;
	if( y<30 && h+30<screen.height ) y = 30;

	var opt = "help:no;center:no;resizable:yes;status:no;";
		// center...centers to opening window
	opt += "dialogLeft:" + x + "px;";
	opt += "dialogTop:" + y + "px;";
	opt += "dialogWidth:" + kDlgWidth + "px;";
	opt += "dialogHeight:" + h + "px;";	
	

	gFeedbackDlg = window.showModelessDialog( "dhtmlHelpFeedback.htm", feedback, opt );
}
